package gov.va.med.mhv.usermgmt.web.controller;

import java.io.Serializable;
import java.util.Map;

import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.RequestScoped;
import javax.faces.context.FacesContext;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.mhv.common.api.dto.EmergencyContactDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;
import gov.va.med.mhv.usermgmt.web.converter.EmergencyContactConverter;
import gov.va.med.mhv.usermgmt.web.converter.EmergencyContactDTOConverter;
import gov.va.med.mhv.usermgmt.web.formbean.EmergencyContact;
import gov.va.med.mhv.usermgmt.web.formbean.UserProfileSession;

@ManagedBean
@RequestScoped
public class EmergencyContactController implements Serializable {
	private static final long serialVersionUID = 1L;
	private static Logger log = LogManager.getLogger(EmergencyContactListController.class);

	private static String GENERAL_ERROR = "An unknown exception occurred.";
	private static String SAVE_SUCCESS = "You have successfully saved emergency contact information.";
	private static String ADD_SUCCESS = "You have successfully saved emergency contact information.";

	@ManagedProperty("#{emergencyContactConverter}")
	private EmergencyContactConverter emergencyContactConverter;

	@ManagedProperty("#{emergencyContactDTOConverter}")
	private EmergencyContactDTOConverter emergencyContactDTOConverter;

	@ManagedProperty("#{userMgmtServiceProxy}")
	private UserMgmtService userMgmtServiceProxy;

	@ManagedProperty("#{userProfileSession}")
	private UserProfileSession userProfileSession;

	@ManagedProperty("#{param.ec}")
	private Long emergencyContactId;

	private EmergencyContact emergencyContact = new EmergencyContact();

	@PostConstruct
	public void init() {
		log.debug("@PostConstruct");

		log.debug("emergencyContactId=" + emergencyContactId);
		loadModel();
	}
	
	private void loadModel() {
		if (emergencyContactId != null && emergencyContactId > 0) {
			try {
				log.debug("getting emergency contact");
				EmergencyContactDTO dto = userMgmtServiceProxy.getEmergencyContact(emergencyContactId);
				log.debug("converting emergency contact");
				emergencyContact = emergencyContactConverter.convert(dto);
				log.debug("done getting emergency contact");
			} catch (MHVException e) {
				log.error(e);
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, GENERAL_ERROR, GENERAL_ERROR));
			}
		}	
	}

	public String saveContact() {
		String nextPage = null;

		try {
			log.debug("saving param.emergencyContactId=" + emergencyContactId);
			log.debug("saving dto.emergencyContactId=" + emergencyContact.getEmergencyContactId());

			EmergencyContactDTO emergencyContactDTO = emergencyContactDTOConverter.convert(emergencyContact);

			if (emergencyContactDTO.getId() == null || emergencyContactDTO.getId() == 0) {
				// if new emergency contact, set default required fields for
				// database
				emergencyContactDTO.setId(null);
				emergencyContactDTO.setOplock(0);
				emergencyContactDTO.setUserProfileId(userProfileSession.getUserProfileId());
			}

			log.debug(emergencyContactDTO);

			userMgmtServiceProxy.saveEmergencyContact(emergencyContactDTO);

			log.debug("after save");

			String msg = (emergencyContactId == null ? ADD_SUCCESS : SAVE_SUCCESS);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg));

			nextPage = "list";

		} catch (MHVException ex) {
			log.error(ex);

			Map<String, String> map = ex.getValidationErrorMessages();
			if (map != null) {
				for (Map.Entry<String, String> entry : map.entrySet()) {
					if (log.isDebugEnabled()) {
						log.debug("entry.getKey() : " + entry.getKey());
						log.debug("entry.getValue() : " + entry.getValue());
					}
					FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
				}
			} else {
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, GENERAL_ERROR, GENERAL_ERROR));
			}
		} catch (Exception e) {
			log.error(e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, GENERAL_ERROR, GENERAL_ERROR));
		}

		return nextPage;
	}

	public EmergencyContactConverter getEmergencyContactConverter() {
		return emergencyContactConverter;
	}

	public void setEmergencyContactConverter(EmergencyContactConverter emergencyContactConverter) {
		this.emergencyContactConverter = emergencyContactConverter;
	}

	public EmergencyContactDTOConverter getEmergencyContactDTOConverter() {
		return emergencyContactDTOConverter;
	}

	public void setEmergencyContactDTOConverter(EmergencyContactDTOConverter emergencyContactDTOConverter) {
		this.emergencyContactDTOConverter = emergencyContactDTOConverter;
	}

	public UserMgmtService getUserMgmtServiceProxy() {
		return userMgmtServiceProxy;
	}

	public void setUserMgmtServiceProxy(UserMgmtService userMgmtServiceProxy) {
		this.userMgmtServiceProxy = userMgmtServiceProxy;
	}

	public UserProfileSession getUserProfileSession() {
		return userProfileSession;
	}

	public void setUserProfileSession(UserProfileSession userProfileSession) {
		this.userProfileSession = userProfileSession;
	}

	public Long getEmergencyContactId() {
		return emergencyContactId;
	}

	public void setEmergencyContactId(Long emergencyContactId) {
		this.emergencyContactId = emergencyContactId;
	}

	public EmergencyContact getEmergencyContact() {
		return emergencyContact;
	}

	public void setEmergencyContact(EmergencyContact emergencyContact) {
		this.emergencyContact = emergencyContact;
	}

}
